﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter_10
{
    class Program
    {
        static void Main(string[] args)
        {
            WebSite site = new WebSite();
            bool isValid = site.IsValidUrl("http://www.informit.com");

            // parametry wartościowe

            WebSite site2 = new WebSite();
            site2.Url = "www.informit.com";

            bool changed = site.UpdateSite(site2);

            Console.WriteLine("URL zmieniony? {0}, URL: {1}", changed, site2.Url);

            // parametry referencyjne

            var loc = new Location();
            loc.Lat = 2;
            loc.Lon = 4;

            bool success = site.PredictLocation(ref loc);
            Console.WriteLine("Lat: {0}, Lon: {1}", loc.Lat, loc.Lon);

            // parametry wyjściowe
            success = Location.TryParse("5.3,7.2", out loc);
            Console.WriteLine("Lat: {0}, Lon: {1}", loc.Lat, loc.Lon);

            // parametry params
            string fullPath = CombinePath(
                Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles),
                "Microsoft.NET\\", "\\\\SDK\\", "v3.5");

            Console.WriteLine(fullPath);

            // metody przeciążone

            isValid = site.IsValidUrl("http://www.informit.com");

            Uri url = new Uri("http://www.informit.com");
            isValid = site.IsValidUrl(url);

            isValid = site.IsValidUrl(url, "https");

            // przeciążanie operatorów

            Vector vect1 = new Vector();
            Vector vect2 = new Vector();

            vect1[0] = vect2[0] = 3;
            vect1[1] = vect2[1] = 5;
            vect1[2] = vect2[2] = 7;
            vect1[3] = vect2[3] = 9;

            Vector vectResult = vect1 + vect2;

            Console.WriteLine(vectResult);

            WebSite site3 = new WebSite();
            WebSite site4 = new WebSite();

            site3.Url = site4.Url = "http://www.informit.com";

            bool equalUrls1 = site3.Equals(site4);
            bool equalUrls2 = site3 == site4;

            Console.WriteLine(
                "site3.Equals(site4): {0}\nsite3 == site4: {1}",
                equalUrls1, equalUrls2);

            // konwersje

            RunConversionDemos();

            // metody rozszerzające

            string progFiles = Environment.GetFolderPath(
                Environment.SpecialFolder.ProgramFiles);

            fullPath = progFiles.CombinePath(
                "Microsoft.NET\\", "\\\\SDK\\", "v3.5");

            Console.WriteLine(fullPath);

            int pos = fullPath.IndexOf("Microsoft");

            Console.WriteLine("Pozycja: " + pos);



            Console.ReadKey();
        }

        private static void RunConversionDemos()
        {
            int myInt = 5;
            long myLong = myInt;

            myLong = 5;
            myInt = (int)myLong;

            int mySigned = -1;
            uint myUnsigned = (uint)mySigned;  // myUnsigned = 4294967295

            ushort myShort1 = 3, myShort2 = 5;
            int result = myShort1 + myShort2;

            myShort1 = 3;
            myShort2 = 5;
            result = (ushort)(myShort1 + myShort2);

            float myFloat;

            double posInfinity =
                        999999999999999999999999999999999999999.0;
            myFloat = (float)posInfinity;  // myFloat = Infinity

            double negInfinity =
                        -999999999999999999999999999999999999999.0;
            myFloat = (float)negInfinity;  // myFloat = -Infinity

            double zeroDouble =
                        0.0000000000000000000000000000000000000000000001;
            myFloat = (float)zeroDouble;  // myFloat = 0

            double myDouble = Double.NaN;
            myFloat = (float)myDouble;   // myFloat = NaN

            decimal myDecimal;

            posInfinity =
                        999999999999999999999999999999999999999.0;
            negInfinity =
                        -999999999999999999999999999999999999999.0;
            double tooLarge = 99999999999999999999999999999.0;
            double doubleNaN = Double.NaN;
            zeroDouble =
                        0.0000000000000000000000000000000000000000000001;

            //myDecimal = (decimal)posInfinity; // OverflowException
            //myDecimal = (decimal)negInfinity; // OverflowException
            //myDecimal = (decimal)tooLarge;    // OverflowException
            //myDecimal = (decimal)double.NaN;  // OverflowException

            myDecimal = (decimal)zeroDouble; // myDecimal = 0

            Currency myCurrency;

            myCurrency = 9.3f;
            Console.WriteLine("myCurrency: {0}", myCurrency);

            myFloat = (float)myCurrency;
            Console.WriteLine("myFloat: {0}", myFloat);

            myDouble = (double)myCurrency;
            Console.WriteLine("myDouble: {0}", myDouble);

            CurrencyType myCurrType = 0;  // myCurrType = Dollar

            BaseClass bc = new BaseClass(1);
            DerivedClass dc = new DerivedClass(2, 3);

            bc = dc;
            //dc = bc; // błąd czasu kompilacji
            dc = (DerivedClass)bc;

        }

        public static string CombinePath(params string[] segments)
        {
            var segTmp = new string[segments.Length + 1];

            for (int i = 0; i < segments.Length; i++)
            {
                segTmp[i] = segments[i].Trim().Trim('\\');
            }

            return string.Join("\\", segTmp);
        }

    }
}
